/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import pregenerator.common.generator.RetrogenManager;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.CommandBuilder;
import pregenerator.common.utils.misc.CommandWrapper;

public class RetrogenCommand {
    public static CommandBuilder createRetogenCommand() {
        CommandBuilder start = new CommandBuilder("retrogen");
        start.addLiteral("add");
        start.addArgument((ArgumentBuilder<CommandSourceStack, ?>)((RequiredArgumentBuilder)Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(RetrogenCommand::add)).suggests((K, V) -> SharedSuggestionProvider.m_82926_(RetrogenManager.INSTANCE.getInactiveFeatures(), (SuggestionsBuilder)V))).popTop();
        start.addLiteral("remove");
        start.addArgument((ArgumentBuilder<CommandSourceStack, ?>)((RequiredArgumentBuilder)Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(RetrogenCommand::remove)).suggests((K, V) -> SharedSuggestionProvider.m_82926_(RetrogenManager.INSTANCE.getActiveFeatures(), (SuggestionsBuilder)V))).popTop();
        start.addLiteral("show", (Command<CommandSourceStack>)((Command)RetrogenCommand::show)).popTop();
        return start;
    }

    private static int add(CommandContext<CommandSourceStack> source) {
        if (ServerManager.INSTANCE.hasRetroBlockingTask()) {
            ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent("Retrogen Settings can not be changed while a Pregenerator is Running"), true);
            return 0;
        }
        ResourceLocation location = (ResourceLocation)source.getArgument("id", ResourceLocation.class);
        if (BuiltinRegistries.f_123861_.m_7804_(location)) {
            RetrogenManager.INSTANCE.enableFeature(location);
            ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent("Added [" + location + "] to the Retrogensettings"), true);
        }
        return 0;
    }

    private static int remove(CommandContext<CommandSourceStack> source) {
        if (ServerManager.INSTANCE.hasRetroBlockingTask()) {
            ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent("Retrogen Settings can not be changed while a Pregenerator is Running"), true);
            return 0;
        }
        ResourceLocation location = (ResourceLocation)source.getArgument("id", ResourceLocation.class);
        if (BuiltinRegistries.f_123861_.m_7804_(location)) {
            RetrogenManager.INSTANCE.disableFeature(location);
            ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent("Removed [" + location + "] from the Retrogensettings"), true);
        }
        return 0;
    }

    private static int show(CommandContext<CommandSourceStack> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        Set<ResourceLocation> locations = RetrogenManager.INSTANCE.getActiveFeatures();
        if (locations.isEmpty()) {
            wrapper.sendFeedBackMessage("No Retrogen Features active");
            return 0;
        }
        wrapper.sendFeedBackMessage("[" + locations.size() + "] Retrogen Features Enabled");
        for (ResourceLocation location : locations) {
            wrapper.sendErrorMessage(location.toString());
        }
        return 0;
    }
}

